(function($) {
	'use strict';
	
	$(document).ready(function() {
        // Initialize the floating promo banner
		initFloatingPromo();
	});
	
	function initFloatingPromo() {
		var $banner = $('#floating-promo-banner');
		if ($banner.length === 0) return;
		
        // Handle close button
		$banner.on('click', '.floating-promo-close', function(e) {
			e.preventDefault();
			e.stopPropagation();
			
            // Animate closing
			$banner.animate({
				opacity: 0,
				bottom: '-100px'
			}, 500, function() {
				$(this).hide();
			});
			
            // Set cookie to remember closed state (30 days)
			setCookie('floating_promo_closed', 'true', 30);
		});
		
        // Handle move button
		$banner.on('click', '.floating-promo-move', function(e) {
			e.preventDefault();
			e.stopPropagation();
			
            // Get current position
			var currentPosition = 'center';
			if ($banner.hasClass('floating-promo-right')) {
				currentPosition = 'right';
			} else if ($banner.hasClass('floating-promo-left')) {
				currentPosition = 'left';
			}
			
            // Determine new position
			var newPosition;
			if (currentPosition === 'center') {
				newPosition = 'right';
			} else if (currentPosition === 'right') {
				newPosition = 'left';
			} else {
				newPosition = 'center';
			}
			
            // Update position class
			$banner.removeClass('floating-promo-right floating-promo-left floating-promo-center')
			.addClass('floating-promo-' + newPosition);
			
            // Set cookie to remember position (30 days)
			setCookie('floating_promo_position', newPosition, 30);
		});
		
        // Prevent link click from triggering move/close
		$banner.find('.floating-promo-link').on('click', function(e) {
			e.stopPropagation();
		});
	}
	
    // Utility function to set cookie
	function setCookie(name, value, days) {
		var expires = '';
		if (days) {
			var date = new Date();
			date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
			expires = '; expires=' + date.toUTCString();
		}
		document.cookie = name + '=' + (value || '') + expires + '; path=/; samesite=lax';
	}
	
})(jQuery);