<?php
// Mengaktifkan fitur-fitur WordPress
function parawangsa_setup() {
    // Menambahkan dukungan untuk title tag
	add_theme_support('title-tag');
	
    // Menambahkan dukungan untuk custom logo
	add_theme_support('custom-logo');
	
    // Menambahkan dukungan untuk post thumbnails
	add_theme_support('post-thumbnails');
	
    // Menambahkan dukungan untuk menu
	register_nav_menus(array(
		'primary' => __('Menu Utama', 'parawangsa'),
	));
	
    // Menambahkan dukungan untuk HTML5
	add_theme_support('html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	));
}
add_action('after_setup_theme', 'parawangsa_setup');

// Memuat stylesheet dan script
function parawangsa_scripts() {
    // Google Fonts
	wp_enqueue_style('google-fonts', 'https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
	
    // Font Awesome
	wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css');
	
    // Style.css utama
	wp_enqueue_style('parawangsa-style', get_stylesheet_uri());
	
    // Script kustom
	wp_enqueue_script('parawangsa-script', get_template_directory_uri() . '/js/script.js', array(), '1.0', true);
}
add_action('wp_enqueue_scripts', 'parawangsa_scripts');

// Widget area untuk footer
function parawangsa_widgets_init() {
	register_sidebar(array(
		'name'          => __('Footer Area 1', 'parawangsa'),
		'id'            => 'footer-1',
		'description'   => __('Widget area untuk footer kolom 1', 'parawangsa'),
		'before_widget' => '<div class="footer-col">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	));
	
	register_sidebar(array(
		'name'          => __('Footer Area 2', 'parawangsa'),
		'id'            => 'footer-2',
		'description'   => __('Widget area untuk footer kolom 2', 'parawangsa'),
		'before_widget' => '<div class="footer-col">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	));
	
	register_sidebar(array(
		'name'          => __('Footer Area 3', 'parawangsa'),
		'id'            => 'footer-3',
		'description'   => __('Widget area untuk footer kolom 3', 'parawangsa'),
		'before_widget' => '<div class="footer-col">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	));
}
add_action('widgets_init', 'parawangsa_widgets_init');
?>